

<?php $__env->startSection('title', 'Complete'); ?>
<?php $__env->startSection('subtitle', 'Upgrade completed successfully'); ?>

<?php $__env->startSection('content'); ?>
    <div style="text-align: center;">
        <div class="completion-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Upgrade Completed!</h2>
        
        <p style="margin-bottom: var(--spacing-xl);">
            Your application has been successfully upgraded. You can now enjoy the latest features and improvements.
        </p>
        
        <div class="info-card" style="max-width: 450px; margin: 0 auto; text-align: left;">
            <h3><i class="fas fa-info-circle"></i> Upgrade Details</h3>
            
            <div class="info-item">
                <div class="info-label">New Version</div>
                <div class="info-value" style="color: var(--success); font-weight: 600;"><?php echo e($newVersion); ?></div>
            </div>
            
            <div class="info-item">
                <div class="info-label">Upgrade Date</div>
                <div class="info-value"><?php echo e(date('Y-m-d H:i:s')); ?></div>
            </div>
            
            <div class="info-item">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <span style="color: var(--success);">
                        <i class="fas fa-check-circle"></i> Success
                    </span>
                </div>
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-xl); background-color: rgba(76, 217, 100, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-lg); text-align: left; border: 1px solid rgba(76, 217, 100, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-lightbulb" style="color: var(--success); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <div>
                    <p style="font-weight: 500; margin-bottom: var(--spacing-xs);">What's next?</p>
                    <ul style="padding-left: var(--spacing-lg); margin-bottom: 0;">
                        <li style="margin-bottom: var(--spacing-xs);">Clear your browser cache for the best experience</li>
                        <li style="margin-bottom: var(--spacing-xs);">Check the changelog for new features</li>
                        <li>Test your application to ensure everything works correctly</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-xl); background-color: rgba(75, 139, 255, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-lg); text-align: left; border: 1px solid rgba(75, 139, 255, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-shield-alt" style="color: var(--primary-color); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <div>
                    <p style="font-weight: 500; margin-bottom: var(--spacing-xs);">Backup Available</p>
                    <p style="font-size: 0.9rem; margin: 0;">
                        A backup of your previous version has been saved. You can find it in the backups section if you need to rollback in the future.
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <div></div>
    <a href="<?php echo e(url('/')); ?>" class="btn btn-success">
        <i class="fas fa-home"></i> Go to Homepage
    </a>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('upgrade.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/upgrade/complete.blade.php ENDPATH**/ ?>